/*  Errechnet die geplante effektive Arbeitszeit aus den Einträgen der Tabelle scheduling.resoure_timeline für einen gegebenen
    AG im vorgegebenen Zeitfenster und ggf. vorgegebener Resource-ID.

    Wird keine Resource-ID vorgegeben, wird die Resource-ID der Hauptresource verwendet.

    Dabei werden nur die Zeiten der Zeistlots der Hauptressource summiert. Zeitslots der KKS werden ignoriert. Sonst käme es zu
    einer Doppeltzählung (Zeiten der Hauptressource des AG + Zeiten der KKS des AG).

    Diese Funktion ist ähnlich der scheduling.ab2__required_worktime__get(), beachtet aber Dinge wie Auswärtskostenstelle,
    gestempelte Zeiten und manuelle Korrekturen der notwendige Arbeitszeit nicht. Dafür kann die Ermittlung der geplanten Zeit
    auf ein Zeitfenster eingeschränkt werden. Dabei kann über das Zeitfenster auch die Dauer von Teilen von Timeline-Einträgen
    berechnet werden.

    Sind keine Task-Blöcke für die Kombination aus gegebenen AG und Zeitraum in der Tabelle resource_timeline eingetragen,
    gibt die Funktion NULL zurück.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__ab2__get_scheduled_time', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__ab2__get_scheduled_time(
    _ab2_id                         int,
    _ti_types                       scheduling.resource_timeline_blocktype[] DEFAULT ARRAY[ 'task' ]::scheduling.resource_timeline_blocktype[],
    _timeframe_start                timestamp DEFAULT '-infinity',
    _timeframe_end                  timestamp DEFAULT 'infinity',
    _resource_id                    int       DEFAULT null
) RETURNS numeric AS $$

      SELECT
          coalesce(
              sum(
                  extract( epoch FROM least( ti_date_end, _timeframe_end ) - greatest( ti_date_start, _timeframe_start ) )
                * ti_ta_kf
              )::numeric
            , 0
          )
      FROM scheduling.resource_timeline
      JOIN ab2_wkstplan ON a2w_a2_id = ti_a2_id
                       AND NOT a2w_marked = -1
      WHERE     ti_a2_id = _ab2_id
            AND ti_type = ANY( _ti_types )
            AND ti_date_end > _timeframe_start -- Überdeckung Zeitbereich mit Timelineeintrag
            AND ti_date_start < _timeframe_end -- Überdeckung Zeitbereich mit Timelineeintrag
            AND ti_resource_id = coalesce( _resource_id, a2w_resource_id_main_terminated ) -- coalesce( _resource_id, scheduling.resource_timeline__resource_id_main_resource__get( _ab2_id ) )

  $$ LANGUAGE sql STABLE PARALLEL SAFE;